# Blockchain Forensics using Graph Temporal Logic ![](https://img.shields.io/badge/-Live-brightgreen)
![](https://img.shields.io/badge/Batch-21CYS-green) ![](https://img.shields.io/badge/Domain-Blockchain-blue) ![](https://img.shields.io/badge/M.Tech--Thesis-WIP-orange) ![](https://img.shields.io/badge/Focus-Forensics-yellow) ![](https://img.shields.io/badge/Focus-OSINT-yellow) ![](https://img.shields.io/badge/AmritaBlockchain-WIP-orange) <br/>
![](https://img.shields.io/badge/Blockchain-Bitcoin-blue) ![](https://img.shields.io/badge/Blockchain-Ethereum-blue)

## Problem Statement

## Background

## Abstract

Detection of Illegal and Malicious accounts and transactions in Blockchain through ev-
idences collected from blockchain (on-chain) and related sources (off-chain) by Open
Source Intelligence (OSINT) and analysis through Graph Temporal Properties. Blockchain
is a decentralized computing distributed ledger platform that enables us to store im-
mutable transactions. In an open and transparent system, it makes logical decisions
involving several stakeholders. In this paper, we are compiling a list of addresses that
have been reported on social media, and using the information we have gathered, we will
check the blockchain explorer and extract the address along with the transaction’s date,
time, and amount. This procedure is referred to as being “on-chain.” With the gathered
information, we create a dataset and conduct Off-chain Open Source Intelligence (OS-
INT) on the addresses to see whether they have appeared somewhere else online, such as
forums, Wikileaks, or other websites.
With the use of OSINT, we will utilise our techniques to determine the wallet address
of that user, and we will then use Graph Temporal Properties to examine the information
we have gathered. In Graph Temporal properties, we are uploading the dataset that we
created. When the graph gets executed, we will have an idea of how many times the
malicious address made contact with other collected addresses, and here we can find the
neighborhood stability and attractive for every address that we gave in the temporal
graph. Here we have to take Graph Temporal for the malicious address per day, week,
and month. Using the temporal graph, we can determine which addresses have the most
communication with the malicious account, we will filter those addresses and do both Off-
chain and On-chain Open Source Intelligence on those addresses. If any of these address
identities are disclosed on the internet, we can readily determine what the malicious
account conducts, such as fraud, ransomware, silk route, and so on.

## Architecture Diagram

## Results

## Acknowledgement

We would like to acknowldge the support provided by **TIFAC-CORE in Cyber Security**, Amrita School of Engineering, Amrita Vishwa Vidyapeetham, Coimbatore, India in carrying out this work as part of "**M.Tech Cyber Security**" Thesis. 

#### Guide : Dr. Chungath Srinivasan, Assistant Professor, TIFAC-CORE in Cyber Security, ASE - Coimbatore
#### Co-Guide : Mr. Ramaguru Radhakrishnan, Assistant Professor, TIFAC-CORE in Cyber Security, ASE - Coimbatore

## References

### Tools

 - [Chainalysis: The Blockchain Data Platform](https://www.chainalysis.com/)
 - [OXT.me](https://oxt.me/)
 - [Bitcoin Abuse Database](https://www.bitcoinabuse.com/)
 - [Mitaka](https://github.com/ninoseki/mitaka)
 - [Arkham Intelligence](https://www.arkhamintelligence.com/)

### Research Papers and Articles

 - Agarwal, R., Barve, S. & Shukla, S.K. **Detecting malicious accounts in permissionless blockchains using temporal graph properties.** Appl Netw Sci 6, 9 (2021). [https://doi.org/10.1007/s41109-020-00338-3](https://doi.org/10.1007/s41109-020-00338-3)
 - Fleder, M., Kester, M. S., & Pillai, S. (2015). **Bitcoin transaction graph analysis.** arXiv preprint arXiv:1502.01657.

## Publications

TBD
