package com.example.kiran.carrents;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.AsyncTask;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.ContextMenu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.Toast;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public class Admindelete extends AppCompatActivity {
    ListView lv;
    String[] car;
    ProgressDialog progressDialog1,pdia;
    String[] ids;
    int i;
    String delcar;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_admindelete);
        lv=(ListView)findViewById(R.id.listview1);
        new loadcars().execute();
        registerForContextMenu(lv);
    }



    class loadcars extends AsyncTask<Void,Void,String[]> {
        @Override
        protected void onPostExecute(String[] strings) {
            super.onPostExecute(strings);
            ArrayAdapter arrayAdapter = new ArrayAdapter(Admindelete.this,android.R.layout.simple_list_item_1,strings);
            lv.setAdapter(arrayAdapter);
            progressDialog1.dismiss();
        }


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressDialog1 = new ProgressDialog(Admindelete.this);
            progressDialog1.setMessage("loading cars...");
            progressDialog1.show();
        }

        @Override
        protected String[] doInBackground(Void... params) {
            String link = "https://carrentscom.000webhostapp.com/admindelete.php";
            try {
                URL url = new URL(link);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setConnectTimeout(1000000);
                conn.setReadTimeout(1500000);
                InputStream inputStream = conn.getInputStream();
                conn.connect();
                int response = conn.getResponseCode();
                inputStream = conn.getInputStream();
// Convert the InputStream into a string
                String contentAsString = convertInputToString(inputStream, 500);
                Log.d("connected",Integer.toString(response));
                Log.d("connected",contentAsString);
                Log.d("connected","connceted");
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> clist = new ArrayList<String>();
                ArrayList<String> ids1 = new ArrayList<>();
                if(contentAsString.charAt(0)=='{'){
                    JSONObject data = new JSONObject(contentAsString);
                    JSONArray menuItemArray = data.getJSONArray("items");
                    int len = menuItemArray.length();
                    for (int i = 0;i<len;i++) {
                        JSONObject item = menuItemArray.getJSONObject(i);
                        String id = item.getString("car_id");
                        String model = item.getString("car_model");
                        arrayList.add(id+"\t\t\t"+model);
                        clist.add(id+"\t\t\t"+model);
                        ids1.add(id);

                    }
                }
                String[] array = arrayList.toArray(new String[0]);
                car = clist.toArray(new String[0]);
                ids = ids1.toArray(new String[0]);
                return  array;
            } catch (Exception e) {
                Log.d("inbackground",e.getMessage());
                String[] str = {"error in loading"};
                return  str;
            }
        }
        public String convertInputToString(InputStream stream, int len)
                throws IOException, UnsupportedEncodingException {
            Reader reader = null;
            reader = new InputStreamReader(stream, "UTF-8");
            char[] buffer = new char[len];
            reader.read(buffer);
            Log.d("readpage",new String(buffer));
            return new String(buffer);
        }

    }


    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        super.onCreateContextMenu(menu, v, menuInfo);
        menu.add("Delete");
    }

    @Override
    public boolean onContextItemSelected(MenuItem item) {
        super.onContextItemSelected(item);
        if(item.getTitle()=="Delete"){
            //Toast.makeText(this,"Hello ...",Toast.LENGTH_LONG).show();
            AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo) item.getMenuInfo();
            int index = info.position;
            delcar = ids[index];
            Toast.makeText(this,delcar,Toast.LENGTH_LONG).show();


            new deletecar().execute(delcar);

        }

        return true;
    }


    class deletecar extends AsyncTask<String,Void,Integer> {

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            pdia = new ProgressDialog(Admindelete.this);
            pdia.setMessage("Deleting car ...");
            pdia.show();
        }

        @Override
        protected Integer doInBackground(String... params) {

            String uname = params[0];
            String link = new String();

            link = "https://carrentscom.000webhostapp.com/deletecar.php?car_id=" +uname;


            try {
                URL url = new URL(link);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setConnectTimeout(1000000);
                conn.setReadTimeout(1500000);
                InputStream inputStream = conn.getInputStream();
                conn.connect();
                int response = conn.getResponseCode();
                inputStream = conn.getInputStream();
                String contentAsString = convertInputToString(inputStream, 1);
                Log.d("connected", Integer.toString(response));
                Log.d("connected", "connceted");
                int i = Integer.parseInt(contentAsString);
                if (i == 1) {
                    return 1;
                }
                return 0;
            } catch (Exception e) {
                Log.d("indobackground", e.getMessage());
                return 0;
            }
        }

        @Override
        protected void onPostExecute(Integer integer) {
            super.onPostExecute(integer);
            i = integer;
            if (integer == 1) {
                Toast.makeText(Admindelete.this,"Deleted",Toast.LENGTH_LONG).show();
                Intent intent = new Intent(Admindelete.this, Adminconsole.class);
                startActivity(intent);
            }
            if (integer == 0) {
                Toast.makeText(Admindelete.this, "Unknown Error", Toast.LENGTH_SHORT).show();
            }
            pdia.dismiss();
        }

        public String convertInputToString(InputStream stream, int len)
                throws IOException, UnsupportedEncodingException {
            Reader reader = null;
            reader = new InputStreamReader(stream, "UTF-8");
            char[] buffer = new char[len];
            reader.read(buffer);
            Log.d("readpage", new String(buffer));
            return new String(buffer);
        }

    }


}
