package com.example.kiran.carrents;

import android.app.Activity;
import android.content.Intent;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import java.util.ArrayList;

/**
 * Created by kiran on 5/2/2017.
 */

public class RVAdapter extends RecyclerView.Adapter<RVAdapter.eventobjectHolder>{

    ArrayList<eventobject> eventObjects;


    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
    }

    public RVAdapter(ArrayList<eventobject> eventObjects) {
        this.eventObjects = eventObjects;
    }


    @Override
    public eventobjectHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.cardview,parent,false);
        eventobjectHolder eventobjectHolder = new eventobjectHolder(v);
        return eventobjectHolder;

    }

    @Override
    public void onBindViewHolder(eventobjectHolder holder, int position) {
        holder.te1.setText(eventObjects.get(position).Car_id);
        holder.te2.setText(eventObjects.get(position).Car_model);
        holder.te3.setText(eventObjects.get(position).KM);
        holder.te4.setText(eventObjects.get(position).Cost);
    }

    @Override
    public int getItemCount() {
        return eventObjects.size();

    }

    public  class eventobjectHolder extends RecyclerView.ViewHolder {

        CardView cardView;
        TextView te1,te2,te3,te4;

        public eventobjectHolder(View itemView) {
            super(itemView);
            cardView = (CardView) itemView.findViewById(R.id.cv);
            te1 = (TextView)itemView.findViewById(R.id.te1);
            te2 = (TextView)itemView.findViewById(R.id.te2);
            te3 = (TextView)itemView.findViewById(R.id.te3);
            te4 = (TextView)itemView.findViewById(R.id.te4);


            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent i=new Intent(v.getContext(),Bookings.class);
                    i.putExtra("car_id",te1.getText().toString());
                    i.putExtra("car_model",te2.getText().toString());
                    i.putExtra("km/day",te3.getText().toString());
                    i.putExtra("cost",te4.getText().toString());
                    v.getContext().startActivity(i);
                }
            });
        }

    }
}
