package com.example.kiran.carrents;


import android.app.Activity;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class location extends AppCompatActivity{
    Spinner spi;
    ProgressDialog progressDialog1;
    ArrayAdapter arrayAdapter;
    String[] cidlist;
    Button b3,b6;
    String item;
    SharedPreferences sharedpreferences;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_location);
        spi=(Spinner)findViewById(R.id.spinner);
        new loadcourse().execute();

        b3 = (Button)findViewById(R.id.button3);
        b6 = (Button)findViewById(R.id.button6);

        sharedpreferences = getSharedPreferences("com.example.kiran.carrents.MyPREFERENCES", Context.MODE_PRIVATE);
        b3.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                SharedPreferences.Editor editor = sharedpreferences.edit();
                editor.putString("city", item);
                editor.commit();
                Toast.makeText(location.this,"shared preference variable set",Toast.LENGTH_SHORT).show();
                Intent i = new Intent(location.this,uscars.class);
                startActivity(i);
            }
        });

        b6.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent j = new Intent(location.this,bookingstatus.class);
                startActivity(j);
            }
        });

    }

    class loadcourse extends AsyncTask<Void,Void,String[]> {
        @Override
        protected void onPostExecute(String[] strings) {
            super.onPostExecute(strings);
            spi=(Spinner)findViewById(R.id.spinner);
            arrayAdapter = new ArrayAdapter(location.this,android.R.layout.simple_spinner_item,cidlist);
            arrayAdapter.setDropDownViewResource(android.R.layout.simple_dropdown_item_1line);
            spi.setAdapter(arrayAdapter);
            progressDialog1.dismiss();
            spi.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener()
            {
                public void onItemSelected(AdapterView<?> parent, View view, int position, long id)
                {
                    item = parent.getItemAtPosition(position).toString();
                }
                public void onNothingSelected(AdapterView<?> parent)
                {

                }
            });
        }


        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            progressDialog1 = new ProgressDialog(location.this);
            progressDialog1.setMessage("loading cities...");
            progressDialog1.show();
        }

        @Override
        protected String[] doInBackground(Void... params) {
            String link = "https://carrentscom.000webhostapp.com/location.php";
            try {
                URL url = new URL(link);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setConnectTimeout(1000000);
                conn.setReadTimeout(1500000);
                InputStream inputStream = conn.getInputStream();
                conn.connect();
                int response = conn.getResponseCode();
                inputStream = conn.getInputStream();
// Convert the InputStream into a string
                String contentAsString = convertInputToString(inputStream, 5000000);
                Log.d("connected",Integer.toString(response));
                Log.d("connected",contentAsString);
                Log.d("connected","connceted");
                JSONObject data = new JSONObject(contentAsString);
                JSONArray menuItemArray = data.getJSONArray("items");
                ArrayList<String> arrayList = new ArrayList<String>();
                ArrayList<String> clist = new ArrayList<String>();
                int len = menuItemArray.length();
                for (int i = 0;i<len;i++) {
                    JSONObject item = menuItemArray.getJSONObject(i);
                    String City = item.getString("city");
                    String combined = City;
                    arrayList.add(combined);
                    clist.add(City);
                }
                String[] array = arrayList.toArray(new String[0]);
                cidlist = clist.toArray(new String[0]);
                return  array;
            } catch (Exception e) {
                Log.d("inbackground",e.getMessage());
                String[] str = {"error in loading"};
                return  str;
            }
        }
        public String convertInputToString(InputStream stream, int len)
                throws IOException, UnsupportedEncodingException {
            Reader reader = null;
            reader = new InputStreamReader(stream, "UTF-8");
            char[] buffer = new char[len];
            reader.read(buffer);
            Log.d("readpage",new String(buffer));
            return new String(buffer);
        }

    }

}